<?php
/**
 * MultiCRM - Kurulum Ana Sayfası
 * Bu sayfa farklı kurulum seçeneklerini sunar
 */

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MultiCRM - Kurulum</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .install-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
            max-width: 800px;
            width: 100%;
        }
        .install-header {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .install-body {
            padding: 2rem;
        }
        .option-card {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1rem;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .option-card:hover {
            border-color: #25D366;
            box-shadow: 0 5px 15px rgba(37, 211, 102, 0.1);
            transform: translateY(-2px);
        }
        .option-card.selected {
            border-color: #25D366;
            background: #f8fff9;
        }
        .btn-primary {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            border: none;
        }
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(37, 211, 102, 0.4);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="install-card">
            <div class="install-header">
                <h2><i class="fab fa-whatsapp"></i> MultiCRM</h2>
                <p>WhatsApp CRM Sistemi Kurulumu</p>
            </div>
            
            <div class="install-body">
                <h3>Kurulum Seçenekleri</h3>
                <p>MultiCRM'yi kurmak için aşağıdaki seçeneklerden birini seçin:</p>
                
                <div class="row">
                    <!-- Temiz Kurulum -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('clean')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-broom fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Temiz Kurulum</h5>
                                    <small class="text-muted">Düzeltilmiş SQL (Önerilen)</small>
                                </div>
                            </div>
                            <p class="mb-3">Foreign key sorunlarını çözen düzeltilmiş SQL ile kurulum.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Foreign key yönetimi</li>
                                <li><i class="fas fa-check text-success"></i> Doğru tablo sırası</li>
                                <li><i class="fas fa-check text-success"></i> Hata önleme</li>
                                <li><i class="fas fa-check text-success"></i> Temiz kurulum</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Güvenli Kurulum -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('safe')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-shield-alt fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Güvenli Kurulum</h5>
                                    <small class="text-muted">Hata yönetimli</small>
                                </div>
                            </div>
                            <p class="mb-3">Mevcut tabloları kontrol eder, sadece eksik olanları oluşturur.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Mevcut tablo kontrolü</li>
                                <li><i class="fas fa-check text-success"></i> Güvenli tablo oluşturma</li>
                                <li><i class="fas fa-check text-success"></i> Hata yönetimi</li>
                                <li><i class="fas fa-check text-success"></i> Admin kullanıcısı</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Hızlı Kurulum -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('quick')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-bolt fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Hızlı Kurulum</h5>
                                    <small class="text-muted">Sadece tablolar</small>
                                </div>
                            </div>
                            <p class="mb-3">Veritabanı mevcut, sadece tabloları oluşturur. En hızlı yöntem.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Veritabanı bağlantısı</li>
                                <li><i class="fas fa-check text-success"></i> Tablo oluşturma</li>
                                <li><i class="fas fa-check text-success"></i> Varsayılan veriler</li>
                                <li><i class="fas fa-check text-success"></i> Admin kullanıcısı</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Otomatik Kurulum -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('auto')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-magic fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Otomatik Kurulum</h5>
                                    <small class="text-muted">Tam kurulum</small>
                                </div>
                            </div>
                            <p class="mb-3">Tüm ayarlar otomatik yapılır. Veritabanı dahil.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Sistem kontrolü</li>
                                <li><i class="fas fa-check text-success"></i> Veritabanı oluşturma</li>
                                <li><i class="fas fa-check text-success"></i> Tablo kurulumu</li>
                                <li><i class="fas fa-check text-success"></i> Dosya yapılandırması</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Sihirbaz Kurulum -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('wizard')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-wand-magic-sparkles fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Sihirbaz Kurulum</h5>
                                    <small class="text-muted">Adım adım kurulum</small>
                                </div>
                            </div>
                            <p class="mb-3">Adım adım rehberli kurulum. Daha detaylı kontrol.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Sistem kontrolü</li>
                                <li><i class="fas fa-check text-success"></i> Veritabanı ayarları</li>
                                <li><i class="fas fa-check text-success"></i> Bağlantı testi</li>
                                <li><i class="fas fa-check text-success"></i> Kurulum tamamlama</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Manuel Kurulum -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('manual')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-cogs fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Manuel Kurulum</h5>
                                    <small class="text-muted">Gelişmiş kullanıcılar için</small>
                                </div>
                            </div>
                            <p class="mb-3">Manuel olarak her adımı kontrol edin. Maksimum esneklik.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Sistem kontrolü</li>
                                <li><i class="fas fa-check text-success"></i> Veritabanı kurulumu</li>
                                <li><i class="fas fa-check text-success"></i> Dosya yapılandırması</li>
                                <li><i class="fas fa-check text-success"></i> Güvenlik ayarları</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Sistem Kontrolü -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('check')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-search fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Sistem Kontrolü</h5>
                                    <small class="text-muted">Sadece kontrol et</small>
                                </div>
                            </div>
                            <p class="mb-3">Sistem gereksinimlerini kontrol edin. Kurulum yapmaz.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> PHP versiyonu</li>
                                <li><i class="fas fa-check text-success"></i> Uzantı kontrolü</li>
                                <li><i class="fas fa-check text-success"></i> İzin kontrolü</li>
                                <li><i class="fas fa-check text-success"></i> SSL kontrolü</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Veritabanı Güncelleme -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('update')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fas fa-sync-alt fa-2x text-warning me-3"></i>
                                <div>
                                    <h5 class="mb-1">Veritabanı Güncelleme</h5>
                                    <small class="text-muted">Mevcut veritabanını güncelle</small>
                                </div>
                            </div>
                            <p class="mb-3">Facebook ve WhatsApp için veritabanını günceller. Mevcut veriler korunur.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Facebook desteği</li>
                                <li><i class="fas fa-check text-success"></i> Platform ayırımı</li>
                                <li><i class="fas fa-check text-success"></i> Güvenli güncelleme</li>
                            </ul>
                        </div>
                    </div>
                    
                    <!-- Facebook Entegrasyonu -->
                    <div class="col-md-6 mb-3">
                        <div class="option-card" onclick="selectOption('facebook')">
                            <div class="d-flex align-items-center mb-3">
                                <i class="fab fa-facebook-messenger fa-2x text-primary me-3"></i>
                                <div>
                                    <h5 class="mb-1">Facebook Entegrasyonu (Eski)</h5>
                                    <small class="text-muted">Eski Facebook kurulum sihirbazı</small>
                                </div>
                            </div>
                            <p class="mb-3">Eski Facebook Messenger kurulum sihirbazı. Yeni kurulumlar için "Veritabanı Güncelleme" kullanın.</p>
                            <ul class="list-unstyled mb-0">
                                <li><i class="fas fa-check text-success"></i> Facebook webhook</li>
                                <li><i class="fas fa-check text-success"></i> Platform ayırımı</li>
                                <li><i class="fas fa-check text-success"></i> Birleşik arayüz</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-between mt-4">
                    <a href="../index.php" class="btn btn-secondary">
                        <i class="fas fa-arrow-left"></i> Ana Sayfaya Dön
                    </a>
                    
                    <button id="start-btn" class="btn btn-primary" disabled>
                        <i class="fas fa-rocket"></i> Kuruluma Başla
                    </button>
                </div>
                
                <div class="mt-4">
                    <h5>📋 Kurulum Öncesi Hazırlık</h5>
                    <div class="alert alert-info">
                        <h6><i class="fas fa-info-circle"></i> Gereksinimler</h6>
                        <ul class="mb-0">
                            <li><strong>PHP:</strong> 7.4 veya üzeri</li>
                            <li><strong>MySQL:</strong> 5.7 veya üzeri</li>
                            <li><strong>SSL:</strong> WhatsApp webhook için gerekli</li>
                            <li><strong>cURL:</strong> WhatsApp API için gerekli</li>
                        </ul>
                    </div>
                    
                    <div class="alert alert-warning">
                        <h6><i class="fas fa-exclamation-triangle"></i> Önemli Notlar</h6>
                        <ul class="mb-0">
                            <li>Kurulum öncesi veritabanı oluşturmanız önerilir</li>
                            <li>SSL sertifikası WhatsApp webhook için zorunludur</li>
                            <li>Kurulum sonrası admin şifresini değiştirin</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let selectedOption = null;
        
        function selectOption(option) {
            // Tüm seçenekleri temizle
            document.querySelectorAll('.option-card').forEach(card => {
                card.classList.remove('selected');
            });
            
            // Seçili seçeneği işaretle
            event.currentTarget.classList.add('selected');
            selectedOption = option;
            
            // Butonu aktif et
            const startBtn = document.getElementById('start-btn');
            startBtn.disabled = false;
            
            // Buton metnini güncelle
            const optionNames = {
                'clean': 'Temiz Kurulum',
                'safe': 'Güvenli Kurulum',
                'quick': 'Hızlı Kurulum',
                'auto': 'Otomatik Kurulum',
                'wizard': 'Sihirbaz Kurulum',
                'manual': 'Manuel Kurulum',
                'check': 'Sistem Kontrolü',
                'update': 'Veritabanı Güncelleme',
                'facebook': 'Facebook Entegrasyonu (Eski)'
            };
            
            startBtn.innerHTML = `<i class="fas fa-rocket"></i> ${optionNames[option]} Başlat`;
        }
        
        document.getElementById('start-btn').addEventListener('click', function() {
            if (!selectedOption) return;
            
            const urls = {
                'clean': 'clean-setup.php',
                'safe': 'safe-setup.php',
                'quick': 'quick-setup.php',
                'auto': 'auto-setup.php',
                'wizard': 'database-wizard.php',
                'manual': 'install.php',
                'update': 'database-update-wizard.php',
                'check': 'cpanel-check.php',
                'facebook': 'facebook-wizard.php'
            };
            
            window.location.href = urls[selectedOption];
        });
    </script>
</body>
</html>
