<?php
/**
 * MultiCRM Kurulum Scripti
 * Bu dosyayı çalıştırarak veritabanını kurabilirsiniz
 */

// Hata raporlamayı aç
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Veritabanı bağlantı bilgileri
$db_config = [
    'host' => 'localhost',
    'dbname' => 'profajco_multicrm',
    'username' => 'profajco_multicrm',
    'password' => 'multi@@2025'
];

try {
    // Veritabanına bağlan (veritabanı adı olmadan)
    $dsn = "mysql:host={$db_config['host']};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_config['username'], $db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    
    echo "<h2>MultiCRM Kurulum</h2>";
    echo "<p>Veritabanı bağlantısı başarılı!</p>";
    
    // SQL dosyasını oku
    $sqlFile = __DIR__ . '/database.sql';
    if (!file_exists($sqlFile)) {
        throw new Exception("database.sql dosyası bulunamadı!");
    }
    
    $sql = file_get_contents($sqlFile);
    
    // SQL komutlarını ayır ve çalıştır
    $statements = explode(';', $sql);
    
    foreach ($statements as $statement) {
        $statement = trim($statement);
        if (!empty($statement)) {
            try {
                $pdo->exec($statement);
                echo "<p>✓ SQL komutu başarıyla çalıştırıldı</p>";
            } catch (PDOException $e) {
                // Bazı hatalar normal olabilir (tablo zaten var gibi)
                if (strpos($e->getMessage(), 'already exists') === false) {
                    echo "<p>⚠ SQL hatası: " . $e->getMessage() . "</p>";
                }
            }
        }
    }
    
    echo "<h3>Kurulum Tamamlandı!</h3>";
    echo "<p>Veritabanı başarıyla kuruldu. Şimdi <a href='../login.php'>giriş yapabilirsiniz</a>.</p>";
    echo "<p><strong>Varsayılan Giriş Bilgileri:</strong></p>";
    echo "<ul>";
    echo "<li>Email: admin@multicrm.com</li>";
    echo "<li>Şifre: password</li>";
    echo "</ul>";
    echo "<p><em>Güvenlik için ilk girişten sonra şifrenizi değiştirin!</em></p>";
    
} catch (Exception $e) {
    echo "<h3>Kurulum Hatası!</h3>";
    echo "<p>Hata: " . $e->getMessage() . "</p>";
    echo "<p>Lütfen veritabanı bağlantı bilgilerini kontrol edin.</p>";
}
?>
