-- ============================================================================
-- MultiCRM - Chatwoot Style Multi-Tenant Architecture Migration
-- Version: 3.1 - MySQL Compatible
-- Date: 2025-12-03
-- ============================================================================

-- ============================================================================
-- STEP 1: Create Inboxes Table
-- ============================================================================

CREATE TABLE IF NOT EXISTS `inboxes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `workspace_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `channel_type` enum('whatsapp','facebook','instagram','email','sms') NOT NULL,
  `identifier` varchar(100) NOT NULL,
  `phone_number_id` varchar(255) DEFAULT NULL,
  `business_account_id` varchar(255) DEFAULT NULL,
  `access_token` text DEFAULT NULL,
  `verify_token` varchar(255) DEFAULT NULL,
  `webhook_url` varchar(500) DEFAULT NULL,
  `settings` json DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `identifier` (`identifier`),
  KEY `workspace_id` (`workspace_id`),
  KEY `channel_type` (`channel_type`),
  KEY `is_active` (`is_active`),
  FOREIGN KEY (`workspace_id`) REFERENCES `agencies` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================================================
-- STEP 2: Create inbox_members table
-- ============================================================================

CREATE TABLE IF NOT EXISTS `inbox_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inbox_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_inbox_member` (`inbox_id`, `user_id`),
  KEY `inbox_id` (`inbox_id`),
  KEY `user_id` (`user_id`),
  FOREIGN KEY (`inbox_id`) REFERENCES `inboxes` (`id`) ON DELETE CASCADE,
  FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

