<?php
/**
 * Chatbot AI Yönetim Sistemi - Veritabanı Kurulumu
 */

require_once '../config/database.php';

echo "<h2>Chatbot AI - Veritabanı Kurulumu</h2>";

try {
    // 1. chatbots tablosu
    echo "<h3>1. chatbots tablosu oluşturuluyor...</h3>";
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS chatbots (
            id INT PRIMARY KEY AUTO_INCREMENT,
            name VARCHAR(255) NOT NULL,
            type ENUM('sales', 'support', 'info', 'custom') DEFAULT 'custom',
            description TEXT,
            system_prompt TEXT NOT NULL,
            model VARCHAR(100) DEFAULT 'gemini-2.0-flash',
            temperature DECIMAL(2,1) DEFAULT 0.7,
            max_tokens INT DEFAULT 1000,
            is_active TINYINT(1) DEFAULT 1,
            created_by INT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
    echo "<p style='color: green;'>✅ chatbots tablosu oluşturuldu</p>";
    
    // 2. chatbot_knowledge tablosu
    echo "<h3>2. chatbot_knowledge tablosu oluşturuluyor...</h3>";
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS chatbot_knowledge (
            id INT PRIMARY KEY AUTO_INCREMENT,
            chatbot_id INT NOT NULL,
            file_name VARCHAR(255) NOT NULL,
            file_type ENUM('pdf', 'txt', 'docx') NOT NULL,
            file_path VARCHAR(500) NOT NULL,
            content LONGTEXT,
            file_size INT,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (chatbot_id) REFERENCES chatbots(id) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    ");
    echo "<p style='color: green;'>✅ chatbot_knowledge tablosu oluşturuldu</p>";
    
    // 3. conversations tablosuna chatbot_id ekle
    echo "<h3>3. conversations tablosu güncelleniyor...</h3>";
    
    // Önce sütun var mı kontrol et
    $stmt = $pdo->query("SHOW COLUMNS FROM conversations LIKE 'chatbot_id'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE conversations ADD COLUMN chatbot_id INT DEFAULT NULL");
        $pdo->exec("ALTER TABLE conversations ADD FOREIGN KEY (chatbot_id) REFERENCES chatbots(id) ON DELETE SET NULL");
        echo "<p style='color: green;'>✅ conversations tablosuna chatbot_id eklendi</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ chatbot_id sütunu zaten mevcut</p>";
    }
    
    // 4. Örnek chatbot'lar ekle
    echo "<h3>4. Örnek chatbot'lar oluşturuluyor...</h3>";
    
    $stmt = $pdo->query("SELECT COUNT(*) FROM chatbots");
    if ($stmt->fetchColumn() == 0) {
        $pdo->exec("
            INSERT INTO chatbots (name, type, description, system_prompt, created_by) VALUES
            ('Satış Asistanı', 'sales', 'Ürün satışı ve tanıtımı için optimize edilmiş chatbot', 'Sen profesyonel bir satış asistanısın. Müşterilere ürünlerimizi tanıt, sorularını yanıtla ve satışı tamamlamalarına yardımcı ol. Kibar, ikna edici ve yardımsever ol.', 1),
            ('Teknik Destek', 'support', 'Teknik sorunları çözmek için tasarlanmış chatbot', 'Sen teknik destek uzmanısın. Müşterilerin teknik sorunlarını çöz, adım adım yönlendirmeler yap. Net, anlaşılır ve sabırlı ol.', 1),
            ('Bilgi Asistanı', 'info', 'Genel bilgi ve SSS için chatbot', 'Sen bilgi asistanısın. Müşterilere şirket, ürünler ve hizmetler hakkında bilgi ver. Sık sorulan soruları yanıtla. Açık, net ve dostane ol.', 1)
        ");
        echo "<p style='color: green;'>✅ 3 örnek chatbot oluşturuldu</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Chatbot'lar zaten mevcut</p>";
    }
    
    // 5. uploads klasörünü oluştur
    echo "<h3>5. Dosya yükleme klasörü oluşturuluyor...</h3>";
    $upload_dir = __DIR__ . '/../uploads/chatbot_knowledge';
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);
        echo "<p style='color: green;'>✅ uploads/chatbot_knowledge klasörü oluşturuldu</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Klasör zaten mevcut</p>";
    }
    
    echo "<hr>";
    echo "<h2 style='color: green;'>✅ Kurulum Tamamlandı!</h2>";
    echo "<p><a href='../chatbot-ai.php'>Chatbot AI Sayfasına Git →</a></p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Hata: " . $e->getMessage() . "</p>";
}
?>
