<?php
/**
 * Adım 1: Sistem Kontrolü
 */
?>

<h3><i class="fas fa-check-circle"></i> Adım 1: Sistem Kontrolü</h3>
<p>Öncelikle sistem gereksinimlerini kontrol edelim.</p>

<div class="info-box">
    <h5><i class="fas fa-info-circle"></i> Gereksinimler</h5>
    <ul class="mb-0">
        <li>PHP 7.4 veya üzeri</li>
        <li>MySQL 5.7 veya üzeri</li>
        <li>cURL desteği</li>
        <li>SSL sertifikası (WhatsApp webhook için)</li>
    </ul>
</div>

<?php
// Sistem kontrolü
$checks = [];

// PHP versiyonu
$phpVersion = phpversion();
$checks['php'] = [
    'name' => 'PHP Versiyonu',
    'current' => $phpVersion,
    'required' => '7.4+',
    'status' => version_compare($phpVersion, '7.4.0', '>=') ? 'success' : 'error'
];

// Gerekli uzantılar
$requiredExtensions = ['pdo', 'pdo_mysql', 'curl', 'json', 'mbstring'];
$extensionsOk = true;
foreach ($requiredExtensions as $ext) {
    if (!extension_loaded($ext)) {
        $extensionsOk = false;
        break;
    }
}

$checks['extensions'] = [
    'name' => 'PHP Uzantıları',
    'current' => $extensionsOk ? 'Tüm gerekli uzantılar mevcut' : 'Bazı uzantılar eksik',
    'required' => 'PDO, cURL, JSON, mbstring',
    'status' => $extensionsOk ? 'success' : 'error'
];

// SSL kontrolü
$sslActive = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on';
$checks['ssl'] = [
    'name' => 'SSL Sertifikası',
    'current' => $sslActive ? 'HTTPS aktif' : 'HTTP (WhatsApp webhook için HTTPS gerekli)',
    'required' => 'HTTPS aktif',
    'status' => $sslActive ? 'success' : 'warning'
];

// Yazma izinleri
$writable = is_writable('.');
$checks['permissions'] = [
    'name' => 'Dosya İzinleri',
    'current' => $writable ? 'Yazma izni mevcut' : 'Yazma izni yok',
    'required' => 'Yazma izni gerekli',
    'status' => $writable ? 'success' : 'error'
];

// Kontrol sonuçlarını göster
foreach ($checks as $key => $check) {
    $icon = $check['status'] === 'success' ? 'fa-check-circle text-success' : 
            ($check['status'] === 'warning' ? 'fa-exclamation-triangle text-warning' : 'fa-times-circle text-danger');
    $bgClass = $check['status'] === 'success' ? 'bg-light' : 
               ($check['status'] === 'warning' ? 'bg-warning bg-opacity-10' : 'bg-danger bg-opacity-10');
    
    echo "<div class='card mb-3 $bgClass'>";
    echo "<div class='card-body'>";
    echo "<h6><i class='fas $icon'></i> {$check['name']}</h6>";
    echo "<p class='mb-1'><strong>Mevcut:</strong> {$check['current']}</p>";
    echo "<p class='mb-0'><strong>Gerekli:</strong> {$check['required']}</p>";
    echo "</div>";
    echo "</div>";
}

// Genel durum
$allSuccess = true;
$hasWarning = false;
foreach ($checks as $check) {
    if ($check['status'] === 'error') {
        $allSuccess = false;
    } elseif ($check['status'] === 'warning') {
        $hasWarning = true;
    }
}

if ($allSuccess) {
    echo "<div class='success-box'>";
    echo "<h5><i class='fas fa-check-circle'></i> Sistem Gereksinimleri Karşılanıyor</h5>";
    echo "<p>Veritabanı oluşturma işlemine devam edebilirsiniz.</p>";
    echo "</div>";
} elseif ($hasWarning) {
    echo "<div class='info-box'>";
    echo "<h5><i class='fas fa-exclamation-triangle'></i> Uyarılar Var</h5>";
    echo "<p>Bazı uyarılar var ama devam edebilirsiniz. WhatsApp webhook için HTTPS önerilir.</p>";
    echo "</div>";
} else {
    echo "<div class='error-box'>";
    echo "<h5><i class='fas fa-times-circle'></i> Sistem Gereksinimleri Karşılanmıyor</h5>";
    echo "<p>Lütfen yukarıdaki hataları düzelttikten sonra tekrar deneyin.</p>";
    echo "</div>";
}
?>

<div class="d-flex justify-content-between mt-4">
    <a href="?" class="btn btn-secondary">
        <i class="fas fa-refresh"></i> Tekrar Kontrol Et
    </a>
    
    <?php if ($allSuccess || $hasWarning): ?>
        <a href="?step=2" class="btn btn-primary">
            <i class="fas fa-arrow-right"></i> Sonraki Adım
        </a>
    <?php else: ?>
        <button class="btn btn-primary" disabled>
            <i class="fas fa-arrow-right"></i> Sonraki Adım
        </button>
    <?php endif; ?>
</div>
