<?php
/**
 * Adım 2: Veritabanı Bilgileri
 */
?>

<h3><i class="fas fa-database"></i> Adım 2: Veritabanı Bilgileri</h3>
<p>Veritabanı bağlantı bilgilerini girin veya varsayılan değerleri kullanın.</p>

<div class="info-box">
    <h5><i class="fas fa-info-circle"></i> Varsayılan Bilgiler</h5>
    <p>Bu bilgiler cPanel MySQL Database Wizard ile oluşturulacak:</p>
    <ul class="mb-0">
        <li><strong>Database Name:</strong> profajco_multicrm</li>
        <li><strong>Username:</strong> profajco_multicrm</li>
        <li><strong>Password:</strong> multi@@2025</li>
        <li><strong>Host:</strong> localhost</li>
    </ul>
</div>

<form method="POST" action="?step=3">
    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="db_host" class="form-label">Veritabanı Sunucusu</label>
                <input type="text" class="form-control" id="db_host" name="db_host" 
                       value="localhost" required>
                <div class="form-text">Genellikle localhost</div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="mb-3">
                <label for="db_name" class="form-label">Veritabanı Adı</label>
                <input type="text" class="form-control" id="db_name" name="db_name" 
                       value="profajco_multicrm" required>
                <div class="form-text">cPanel'de oluşturacağınız veritabanı adı</div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="db_user" class="form-label">Kullanıcı Adı</label>
                <input type="text" class="form-control" id="db_user" name="db_user" 
                       value="profajco_multicrm" required>
                <div class="form-text">Veritabanı kullanıcı adı</div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="mb-3">
                <label for="db_pass" class="form-label">Şifre</label>
                <input type="password" class="form-control" id="db_pass" name="db_pass" 
                       value="multi@@2025" required>
                <div class="form-text">Güçlü bir şifre kullanın</div>
            </div>
        </div>
    </div>
    
    <div class="mb-3">
        <div class="form-check">
            <input class="form-check-input" type="checkbox" id="create_db" name="create_db" checked>
            <label class="form-check-label" for="create_db">
                Veritabanını otomatik oluştur (önerilen)
            </label>
        </div>
        <div class="form-text">Bu seçenek işaretliyse, veritabanı otomatik oluşturulacak</div>
    </div>
    
    <div class="alert alert-info">
        <h6><i class="fas fa-lightbulb"></i> cPanel Kurulum İpuçları</h6>
        <ol class="mb-0">
            <li><strong>cPanel MySQL Database Wizard</strong> ile veritabanı oluşturun</li>
            <li>Veritabanı adı: <code>profajco_multicrm</code></li>
            <li>Kullanıcı adı: <code>profajco_multicrm</code></li>
            <li>Şifre: <code>multi@@2025</code></li>
            <li>Kullanıcıyı veritabanına ata</li>
        </ol>
    </div>
    
    <div class="d-flex justify-content-between mt-4">
        <a href="?step=1" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Önceki Adım
        </a>
        
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-arrow-right"></i> Bağlantıyı Test Et
        </button>
    </div>
</form>

<script>
// Form validasyonu
document.querySelector('form').addEventListener('submit', function(e) {
    const dbName = document.getElementById('db_name').value;
    const dbUser = document.getElementById('db_user').value;
    const dbPass = document.getElementById('db_pass').value;
    
    if (!dbName || !dbUser || !dbPass) {
        e.preventDefault();
        alert('Lütfen tüm alanları doldurun');
        return;
    }
    
    if (dbPass.length < 8) {
        e.preventDefault();
        alert('Şifre en az 8 karakter olmalıdır');
        return;
    }
});
</script>
