<?php
/**
 * Adım 3: Veritabanı Bağlantı Testi ve Oluşturma
 */

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_name = $_POST['db_name'] ?? 'profajco_multicrm';
    $db_user = $_POST['db_user'] ?? 'profajco_multicrm';
    $db_pass = $_POST['db_pass'] ?? 'multi@@2025';
    $create_db = isset($_POST['create_db']);
    
    $error = '';
    $success = '';
    
    try {
        // Veritabanı bağlantısını test et
        if ($create_db) {
            // Önce veritabanı olmadan bağlan
            $dsn = "mysql:host=$db_host;charset=utf8mb4";
            $pdo = new PDO($dsn, $db_user, $db_pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            ]);
            
            // Veritabanını oluştur
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $success .= "✓ Veritabanı oluşturuldu: $db_name<br>";
        }
        
        // Veritabanına bağlan
        $dsn = "mysql:host=$db_host;dbname=$db_name;charset=utf8mb4";
        $pdo = new PDO($dsn, $db_user, $db_pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]);
        
        $success .= "✓ Veritabanı bağlantısı başarılı<br>";
        
        // SQL dosyasını oku ve çalıştır
        $sqlFile = __DIR__ . '/database.sql';
        if (!file_exists($sqlFile)) {
            throw new Exception("database.sql dosyası bulunamadı!");
        }
        
        $sql = file_get_contents($sqlFile);
        $statements = explode(';', $sql);
        
        $successCount = 0;
        $errorCount = 0;
        
        foreach ($statements as $statement) {
            $statement = trim($statement);
            if (!empty($statement)) {
                try {
                    $pdo->exec($statement);
                    $successCount++;
                } catch (PDOException $e) {
                    // Bazı hatalar normal olabilir (tablo zaten var gibi)
                    if (strpos($e->getMessage(), 'already exists') === false) {
                        $errorCount++;
                    }
                }
            }
        }
        
        $success .= "✓ Tablolar oluşturuldu ($successCount başarılı, $errorCount uyarı)<br>";
        
        // Varsayılan admin kullanıcısını kontrol et
        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM users WHERE email = 'admin@multicrm.com'");
        $stmt->execute();
        $adminExists = $stmt->fetch()['count'] > 0;
        
        if ($adminExists) {
            $success .= "✓ Varsayılan admin kullanıcısı mevcut<br>";
        } else {
            $success .= "⚠ Varsayılan admin kullanıcısı oluşturulmadı<br>";
        }
        
        // Başarılı ise 4. adıma geç
        if (empty($error)) {
            $_SESSION['db_config'] = [
                'host' => $db_host,
                'dbname' => $db_name,
                'username' => $db_user,
                'password' => $db_pass
            ];
            header('Location: ?step=4');
            exit();
        }
        
    } catch (Exception $e) {
        $error = "Veritabanı hatası: " . $e->getMessage();
    }
}
?>

<h3><i class="fas fa-cogs"></i> Adım 3: Veritabanı Kurulumu</h3>
<p>Veritabanı bağlantısını test ediyoruz ve tabloları oluşturuyoruz...</p>

<?php if ($error): ?>
    <div class="error-box">
        <h5><i class="fas fa-times-circle"></i> Hata Oluştu</h5>
        <p><?php echo $error; ?></p>
        
        <div class="mt-3">
            <h6>Olası Çözümler:</h6>
            <ul>
                <li>cPanel MySQL Database Wizard ile veritabanını oluşturun</li>
                <li>Kullanıcı adı ve şifreyi kontrol edin</li>
                <li>Veritabanı kullanıcısının tüm yetkilere sahip olduğundan emin olun</li>
                <li>cPanel'de MySQL servisinin çalıştığını kontrol edin</li>
            </ul>
        </div>
    </div>
<?php endif; ?>

<?php if ($success): ?>
    <div class="success-box">
        <h5><i class="fas fa-check-circle"></i> Kurulum Başarılı!</h5>
        <p><?php echo $success; ?></p>
    </div>
<?php endif; ?>

<div class="info-box">
    <h5><i class="fas fa-info-circle"></i> Kurulum İşlemleri</h5>
    <ul class="mb-0">
        <li>Veritabanı bağlantısı test ediliyor</li>
        <li>Gerekli tablolar oluşturuluyor</li>
        <li>Varsayılan veriler ekleniyor</li>
        <li>Güvenlik ayarları yapılandırılıyor</li>
    </ul>
</div>

<?php if ($error): ?>
    <div class="d-flex justify-content-between mt-4">
        <a href="?step=2" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri Dön
        </a>
        
        <a href="?step=2" class="btn btn-primary">
            <i class="fas fa-refresh"></i> Tekrar Dene
        </a>
    </div>
<?php elseif ($success): ?>
    <div class="d-flex justify-content-between mt-4">
        <a href="?step=2" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Önceki Adım
        </a>
        
        <a href="?step=4" class="btn btn-primary">
            <i class="fas fa-arrow-right"></i> Sonraki Adım
        </a>
    </div>
<?php else: ?>
    <div class="text-center mt-4">
        <div class="spinner-border text-primary" role="status">
            <span class="visually-hidden">Yükleniyor...</span>
        </div>
        <p class="mt-2">Veritabanı kurulumu devam ediyor...</p>
    </div>
    
    <script>
        // Otomatik olarak formu gönder
        setTimeout(() => {
            document.querySelector('form').submit();
        }, 1000);
    </script>
<?php endif; ?>
