<?php
/**
 * Adım 4: Kurulum Tamamlandı
 */

$db_config = $_SESSION['db_config'] ?? null;

if (!$db_config) {
    header('Location: ?step=1');
    exit();
}

// config/database.php dosyasını güncelle
$configContent = "<?php
// MultiCRM Veritabanı Yapılandırması
// Bu dosya otomatik oluşturulmuştur

\$db_config = [
    'host' => '{$db_config['host']}',
    'dbname' => '{$db_config['dbname']}',
    'username' => '{$db_config['username']}',
    'password' => '{$db_config['password']}',
    'charset' => 'utf8mb4'
];

// WhatsApp API ayarları
\$whatsapp_config = [
    'phone_number_id' => '592915763902531',
    'business_account_id' => '1368891014268764',
    'access_token' => 'EACHvoNXB2JoBPv07ycwvjOFqyeZCuGx1saam7WAB11iPhK052AhP7UFz5IVYL0SYe73ZBo2GAE9xl5Y9bk31eyXzZAyMSx7C9fylkR52UNVuMfOokiqlU73uyLw1JT0VZC5bUjMO0ZBl4m0tRyZAbjia9GyxuKZBABH4YFsniweaU8Y7BlJaTiiEJyirPakXaFhpcuQLPZAkLLSrJZCZCyfsZA0ZCvgFSVC1ZB6JwZA2NVRO5e',
    'api_version' => 'v18.0',
    'verify_token' => 'profaj_whatsapp_2024',
    'webhook_url' => 'https://profaj.co/multicrm/api/webhook-whatsapp.php'
];

// PDO veritabanı bağlantısı
try {
    \$dsn = \"mysql:host={\$db_config['host']};dbname={\$db_config['dbname']};charset={\$db_config['charset']}\";
    \$pdo = new PDO(\$dsn, \$db_config['username'], \$db_config['password'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ]);
} catch (PDOException \$e) {
    die(\"Veritabanı bağlantı hatası: \" . \$e->getMessage());
}

// WhatsApp API fonksiyonları
function sendWhatsAppMessage(\$to, \$message, \$type = 'text') {
    global \$whatsapp_config;
    
    \$url = \"https://graph.facebook.com/{\$whatsapp_config['api_version']}/{\$whatsapp_config['phone_number_id']}/messages\";
    
    \$data = [
        'messaging_product' => 'whatsapp',
        'to' => \$to,
        'type' => \$type,
        'text' => ['body' => \$message]
    ];
    
    \$headers = [
        'Authorization: Bearer ' . \$whatsapp_config['access_token'],
        'Content-Type: application/json'
    ];
    
    \$ch = curl_init();
    curl_setopt(\$ch, CURLOPT_URL, \$url);
    curl_setopt(\$ch, CURLOPT_POST, true);
    curl_setopt(\$ch, CURLOPT_POSTFIELDS, json_encode(\$data));
    curl_setopt(\$ch, CURLOPT_HTTPHEADER, \$headers);
    curl_setopt(\$ch, CURLOPT_RETURNTRANSFER, true);
    
    \$response = curl_exec(\$ch);
    \$httpCode = curl_getinfo(\$ch, CURLINFO_HTTP_CODE);
    curl_close(\$ch);
    
    return [
        'success' => \$httpCode === 200,
        'response' => json_decode(\$response, true),
        'http_code' => \$httpCode
    ];
}

// Markdown template gönderimi
function sendWhatsAppTemplate(\$to, \$template_name, \$language = 'tr', \$components = []) {
    global \$whatsapp_config;
    
    \$url = \"https://graph.facebook.com/{\$whatsapp_config['api_version']}/{\$whatsapp_config['phone_number_id']}/messages\";
    
    \$data = [
        'messaging_product' => 'whatsapp',
        'to' => \$to,
        'type' => 'template',
        'template' => [
            'name' => \$template_name,
            'language' => ['code' => \$language],
            'components' => \$components
        ]
    ];
    
    \$headers = [
        'Authorization: Bearer ' . \$whatsapp_config['access_token'],
        'Content-Type: application/json'
    ];
    
    \$ch = curl_init();
    curl_setopt(\$ch, CURLOPT_URL, \$url);
    curl_setopt(\$ch, CURLOPT_POST, true);
    curl_setopt(\$ch, CURLOPT_POSTFIELDS, json_encode(\$data));
    curl_setopt(\$ch, CURLOPT_HTTPHEADER, \$headers);
    curl_setopt(\$ch, CURLOPT_RETURNTRANSFER, true);
    
    \$response = curl_exec(\$ch);
    \$httpCode = curl_getinfo(\$ch, CURLINFO_HTTP_CODE);
    curl_close(\$ch);
    
    return [
        'success' => \$httpCode === 200,
        'response' => json_decode(\$response, true),
        'http_code' => \$httpCode
    ];
}
?>";

// config/database.php dosyasını oluştur
file_put_contents('../config/database.php', $configContent);

// Install dizinini koru
file_put_contents('.htaccess', "Order Allow,Deny\nDeny from all");

// Session'ı temizle
unset($_SESSION['db_config']);
?>

<h3><i class="fas fa-check-circle"></i> Adım 4: Kurulum Tamamlandı!</h3>
<p>MultiCRM sistemi başarıyla kuruldu ve çalışmaya hazır.</p>

<div class="success-box">
    <h5><i class="fas fa-check-circle"></i> Kurulum Başarılı!</h5>
    <p>Veritabanı ve tüm gerekli dosyalar başarıyla oluşturuldu.</p>
</div>

<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-database"></i> Veritabanı Bilgileri</h5>
            </div>
            <div class="card-body">
                <p><strong>Host:</strong> <?php echo htmlspecialchars($db_config['host']); ?></p>
                <p><strong>Database:</strong> <?php echo htmlspecialchars($db_config['dbname']); ?></p>
                <p><strong>Username:</strong> <?php echo htmlspecialchars($db_config['username']); ?></p>
                <p><strong>Password:</strong> ••••••••</p>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-user"></i> Varsayılan Giriş</h5>
            </div>
            <div class="card-body">
                <p><strong>Email:</strong> admin@multicrm.com</p>
                <p><strong>Şifre:</strong> password</p>
                <div class="alert alert-warning mt-2">
                    <small><i class="fas fa-exclamation-triangle"></i> İlk girişten sonra şifrenizi değiştirin!</small>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="info-box mt-4">
    <h5><i class="fas fa-info-circle"></i> Sonraki Adımlar</h5>
    <ol class="mb-0">
        <li><strong>Giriş Yapın:</strong> <a href="../login.php" target="_blank">login.php</a></li>
        <li><strong>WhatsApp Webhook:</strong> WhatsApp Developer Console'da ayarlayın</li>
        <li><strong>Webhook URL:</strong> https://profaj.co/multicrm/api/webhook-whatsapp.php</li>
        <li><strong>Verify Token:</strong> profaj_whatsapp_2024</li>
        <li><strong>İlk Müşteri:</strong> Müşteriler sayfasından ekleyin</li>
    </ol>
</div>

<div class="alert alert-warning mt-4">
    <h6><i class="fas fa-shield-alt"></i> Güvenlik Uyarısı</h6>
    <ul class="mb-0">
        <li>Install dizini artık korunuyor</li>
        <li>Varsayılan admin şifresini değiştirin</li>
        <li>SSL sertifikasının aktif olduğundan emin olun</li>
        <li>Düzenli yedekleme yapın</li>
    </ul>
</div>

<div class="d-flex justify-content-between mt-4">
    <a href="?step=1" class="btn btn-secondary">
        <i class="fas fa-refresh"></i> Yeniden Kur
    </a>
    
    <a href="../index.php" class="btn btn-success">
        <i class="fas fa-rocket"></i> Sistemi Başlat
    </a>
</div>

<script>
// Kurulum tamamlandı bildirimi
if (Notification.permission === 'granted') {
    new Notification('MultiCRM Kurulum Tamamlandı!', {
        body: 'Sistem kullanıma hazır. Giriş yapabilirsiniz.',
        icon: '/multicrm/assets/images/whatsapp-icon.png'
    });
}
</script>
