-- MultiCRM Workspace System Migration
-- This script adds workspace functionality to the existing system

-- Step 1: Add workspace_id to customers table
ALTER TABLE customers 
ADD COLUMN workspace_id INT NOT NULL DEFAULT 1 AFTER id,
ADD INDEX idx_workspace_id (workspace_id),
ADD FOREIGN KEY fk_customer_workspace (workspace_id) REFERENCES agencies(id) ON DELETE RESTRICT;

-- Step 2: Add workspace_id to conversations table
ALTER TABLE conversations 
ADD COLUMN workspace_id INT NOT NULL DEFAULT 1 AFTER id,
ADD INDEX idx_workspace_id (workspace_id),
ADD FOREIGN KEY fk_conversation_workspace (workspace_id) REFERENCES agencies(id) ON DELETE RESTRICT;

-- Step 3: Add workspace_id to settings table (NULL = global settings)
ALTER TABLE settings 
ADD COLUMN workspace_id INT NULL AFTER id,
ADD INDEX idx_workspace_id (workspace_id),
ADD FOREIGN KEY fk_setting_workspace (workspace_id) REFERENCES agencies(id) ON DELETE CASCADE;

-- Step 4: Add is_default to user_agencies table
ALTER TABLE user_agencies 
ADD COLUMN is_default BOOLEAN DEFAULT FALSE AFTER role;

-- Step 5: Create workspace_settings table
CREATE TABLE IF NOT EXISTS workspace_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    workspace_id INT NOT NULL,
    `key` VARCHAR(255) NOT NULL,
    value TEXT,
    type ENUM('string', 'number', 'boolean', 'json') DEFAULT 'string',
    description VARCHAR(500),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY unique_workspace_setting (workspace_id, `key`),
    FOREIGN KEY (workspace_id) REFERENCES agencies(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Step 6: Set default workspace for existing user_agencies
UPDATE user_agencies 
SET is_default = TRUE 
WHERE id IN (
    SELECT min_id FROM (
        SELECT MIN(id) as min_id 
        FROM user_agencies 
        GROUP BY user_id
    ) as subquery
);

-- Step 7: Add platform column to conversations if not exists (for multi-platform support)
ALTER TABLE conversations 
ADD COLUMN platform ENUM('whatsapp', 'facebook', 'instagram', 'email', 'web') DEFAULT 'whatsapp' AFTER workspace_id;

-- Step 8: Add last_message_time to conversations for better sorting
ALTER TABLE conversations 
ADD COLUMN last_message_time TIMESTAMP NULL AFTER updated_at,
ADD INDEX idx_last_message_time (last_message_time);

-- Step 9: Update existing conversations with last message time
UPDATE conversations c
SET last_message_time = (
    SELECT MAX(created_at) 
    FROM messages m 
    WHERE m.conversation_id = c.id
);
