<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔍 BASİT KONTROL\n";
echo "═══════════════════════════════════════════════════════════\n\n";

// Test 1: Config dosyası
echo "1️⃣  CONFIG/DATABASE.PHP:\n";
echo "───────────────────────────────────────────────────────────\n";
if (file_exists('config/database.php')) {
    echo "✅ Dosya var\n";
    try {
        ob_start();
        require_once 'config/database.php';
        $output = ob_get_clean();
        echo "✅ Yüklendi\n";
        if (isset($pdo)) {
            echo "✅ \$pdo tanımlı\n";
        } else {
            echo "❌ \$pdo tanımlı değil\n";
        }
    } catch (Exception $e) {
        $output = ob_get_clean();
        echo "❌ Hata: " . $e->getMessage() . "\n";
        echo "Output: " . $output . "\n";
    }
} else {
    echo "❌ Dosya yok\n";
}

echo "\n2️⃣  INCLUDES/FUNCTIONS.PHP:\n";
echo "───────────────────────────────────────────────────────────\n";
if (file_exists('includes/functions.php')) {
    echo "✅ Dosya var\n";
    
    // Syntax kontrolü
    $output = shell_exec('php -l includes/functions.php 2>&1');
    if (strpos($output, 'No syntax errors') !== false) {
        echo "✅ Syntax OK\n";
    } else {
        echo "❌ Syntax hatası:\n";
        echo $output . "\n";
    }
} else {
    echo "❌ Dosya yok\n";
}

echo "\n3️⃣  INDEX.PHP:\n";
echo "───────────────────────────────────────────────────────────\n";
if (file_exists('index.php')) {
    echo "✅ Dosya var\n";
    
    // Syntax kontrolü
    $output = shell_exec('php -l index.php 2>&1');
    if (strpos($output, 'No syntax errors') !== false) {
        echo "✅ Syntax OK\n";
    } else {
        echo "❌ Syntax hatası:\n";
        echo $output . "\n";
    }
} else {
    echo "❌ Dosya yok\n";
}

echo "\n4️⃣  API/WEBHOOK-FACEBOOK.PHP:\n";
echo "───────────────────────────────────────────────────────────\n";
if (file_exists('api/webhook-facebook.php')) {
    echo "✅ Dosya var\n";
    
    // Syntax kontrolü
    $output = shell_exec('php -l api/webhook-facebook.php 2>&1');
    if (strpos($output, 'No syntax errors') !== false) {
        echo "✅ Syntax OK\n";
    } else {
        echo "❌ Syntax hatası:\n";
        echo $output . "\n";
    }
} else {
    echo "❌ Dosya yok\n";
}

echo "\n═══════════════════════════════════════════════════════════\n";
echo "Sonuçları bana gönderin!\n";
echo "═══════════════════════════════════════════════════════════\n";
?>

