<?php
/**
 * Facebook Webhook Test Script
 * Bu script webhook'un çalışıp çalışmadığını test eder
 */

echo "<h2>Facebook Webhook Test</h2>";
echo "<hr>";

// 1. Config kontrolü
echo "<h3>1. Facebook Config Kontrolü</h3>";
require_once 'config/database.php';

if (isset($facebook_config)) {
    echo "<p style='color:green'>✅ Facebook config yüklendi</p>";
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Ayar</th><th>Değer</th></tr>";
    echo "<tr><td>App ID</td><td>" . $facebook_config['app_id'] . "</td></tr>";
    echo "<tr><td>Page ID</td><td>" . ($facebook_config['page_id'] ?: '<span style=\"color:red\">BOŞ!</span>') . "</td></tr>";
    echo "<tr><td>Verify Token</td><td>" . $facebook_config['verify_token'] . "</td></tr>";
    echo "<tr><td>Webhook URL</td><td>" . $facebook_config['webhook_url'] . "</td></tr>";
    echo "<tr><td>API Version</td><td>" . $facebook_config['api_version'] . "</td></tr>";
    echo "</table>";
} else {
    echo "<p style='color:red'>❌ Facebook config yüklenemedi!</p>";
}

echo "<hr>";

// 2. Webhook dosyası kontrolü
echo "<h3>2. Webhook Dosyası Kontrolü</h3>";
$webhookFile = 'api/webhook-facebook.php';
if (file_exists($webhookFile)) {
    echo "<p style='color:green'>✅ Webhook dosyası mevcut: $webhookFile</p>";
    echo "<p><strong>URL:</strong> <a href='https://profaj.co/multicrm/api/webhook-facebook.php' target='_blank'>https://profaj.co/multicrm/api/webhook-facebook.php</a></p>";
} else {
    echo "<p style='color:red'>❌ Webhook dosyası bulunamadı!</p>";
}

echo "<hr>";

// 3. Log dosyaları kontrolü
echo "<h3>3. Facebook Webhook Logları</h3>";
$logDir = 'logs';
$facebookLogs = glob($logDir . '/facebook_webhook_*.log');

if (empty($facebookLogs)) {
    echo "<p style='color:orange'>⚠️ Hiç Facebook webhook logu yok!</p>";
    echo "<p><strong>Bu şu anlama gelir:</strong></p>";
    echo "<ul>";
    echo "<li>Webhook'a hiç istek gelmemiş</li>";
    echo "<li>Facebook webhook ayarları yapılmamış olabilir</li>";
    echo "<li>Webhook URL'i yanlış olabilir</li>";
    echo "</ul>";
} else {
    echo "<p style='color:green'>✅ " . count($facebookLogs) . " adet log dosyası bulundu</p>";
    echo "<ul>";
    foreach ($facebookLogs as $log) {
        $size = filesize($log);
        $date = date('Y-m-d H:i:s', filemtime($log));
        echo "<li><a href='view-log.php?file=" . basename($log) . "'>" . basename($log) . "</a> - " . number_format($size) . " bytes - Son değişiklik: $date</li>";
    }
    echo "</ul>";
    
    // Son logu göster
    $lastLog = end($facebookLogs);
    echo "<h4>Son Log İçeriği (Son 50 satır):</h4>";
    $lines = file($lastLog);
    $lastLines = array_slice($lines, -50);
    echo "<pre style='background:#f5f5f5; padding:10px; max-height:400px; overflow:auto'>";
    echo htmlspecialchars(implode('', $lastLines));
    echo "</pre>";
}

echo "<hr>";

// 4. Manuel webhook test
echo "<h3>4. Manuel Webhook Test</h3>";
echo "<p>Webhook'u manuel olarak test etmek için:</p>";
echo "<pre style='background:#f5f5f5; padding:10px'>";
echo "curl -X GET 'https://profaj.co/multicrm/api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=test123'";
echo "</pre>";

echo "<p><strong>Beklenen sonuç:</strong> <code>test123</code></p>";

if (isset($_GET['test_webhook'])) {
    echo "<h4>Test Sonucu:</h4>";
    $testUrl = 'https://profaj.co/multicrm/api/webhook-facebook.php?hub.mode=subscribe&hub.verify_token=profaj_whatsapp_2024&hub.challenge=test123';
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $testUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    if ($httpCode === 200 && $response === 'test123') {
        echo "<p style='color:green'>✅ Webhook doğrulama başarılı!</p>";
    } else {
        echo "<p style='color:red'>❌ Webhook doğrulama başarısız!</p>";
        echo "<p>HTTP Code: $httpCode</p>";
        echo "<p>Response: " . htmlspecialchars($response) . "</p>";
    }
}

echo "<p><a href='?test_webhook=1' class='btn'>Webhook'u Test Et</a></p>";

echo "<hr>";

// 5. Facebook ayarları talimatları
echo "<h3>5. Facebook Webhook Kurulum Talimatları</h3>";
echo "<div style='background:#fff3cd; padding:15px; border-left:4px solid #ffc107'>";
echo "<h4>Facebook Developer Console'da yapılması gerekenler:</h4>";
echo "<ol>";
echo "<li><strong>Meta for Developers</strong> sayfasına gidin: <a href='https://developers.facebook.com/apps' target='_blank'>https://developers.facebook.com/apps</a></li>";
echo "<li>Uygulamanızı seçin (App ID: " . ($facebook_config['app_id'] ?? 'N/A') . ")</li>";
echo "<li>Sol menüden <strong>Messenger > Settings</strong> seçin</li>";
echo "<li><strong>Webhooks</strong> bölümünde <strong>Add Callback URL</strong> tıklayın</li>";
echo "<li>Şu bilgileri girin:";
echo "<ul>";
echo "<li><strong>Callback URL:</strong> <code>https://profaj.co/multicrm/api/webhook-facebook.php</code></li>";
echo "<li><strong>Verify Token:</strong> <code>profaj_whatsapp_2024</code></li>";
echo "</ul>";
echo "</li>";
echo "<li><strong>Verify and Save</strong> butonuna tıklayın</li>";
echo "<li><strong>Subscription Fields</strong> bölümünde şunları seçin:";
echo "<ul>";
echo "<li>✅ messages</li>";
echo "<li>✅ messaging_postbacks</li>";
echo "<li>✅ message_deliveries</li>";
echo "<li>✅ message_reads</li>";
echo "</ul>";
echo "</li>";
echo "<li>Sayfanızı webhook'a subscribe edin</li>";
echo "</ol>";
echo "</div>";

echo "<hr>";
echo "<p><a href='index.php'>Ana Sayfaya Dön</a></p>";
?>

<style>
.btn {
    display: inline-block;
    padding: 10px 20px;
    background: #007bff;
    color: white;
    text-decoration: none;
    border-radius: 5px;
}
.btn:hover {
    background: #0056b3;
}
</style>
