<?php
/**
 * Test Workspace Delete API
 * Manuel test için
 */

session_start();
require_once 'config/database.php';
require_once 'includes/functions.php';
require_once 'includes/workspace.php';

// Kullanıcı kontrolü
if (!isset($_SESSION['user_id'])) {
    die("Lütfen giriş yapın");
}

$user = getUserById($_SESSION['user_id']);

if ($user['role'] !== 'admin') {
    die("Bu sayfaya sadece admin erişebilir");
}

// Tüm workspace'leri getir
$stmt = $pdo->query("SELECT * FROM agencies ORDER BY id ASC");
$workspaces = $stmt->fetchAll();

echo "<h1>Workspace Delete Test</h1>";
echo "<p>Kullanıcı: " . htmlspecialchars($user['name']) . " (Role: " . $user['role'] . ")</p>";
echo "<p>Session Workspace ID: " . ($_SESSION['workspace_id'] ?? 'YOK') . "</p>";

echo "<h2>Tüm Workspace'ler:</h2>";
echo "<table border='1' cellpadding='5'>";
echo "<tr><th>ID</th><th>Name</th><th>Domain</th><th>Status</th><th>Test</th></tr>";

foreach ($workspaces as $ws) {
    echo "<tr>";
    echo "<td>" . $ws['id'] . "</td>";
    echo "<td>" . htmlspecialchars($ws['name']) . "</td>";
    echo "<td>" . htmlspecialchars($ws['domain'] ?? '-') . "</td>";
    echo "<td>" . $ws['status'] . "</td>";
    echo "<td>";
    if ($ws['status'] === 'active') {
        echo "<button onclick='testDelete(" . $ws['id'] . ")'>Test Delete</button>";
    } else {
        echo "Zaten pasif";
    }
    echo "</td>";
    echo "</tr>";
}

echo "</table>";

// Aktif workspace sayısı
$stmt = $pdo->query("SELECT COUNT(*) as count FROM agencies WHERE status = 'active'");
$activeCount = $stmt->fetch();
echo "<p><strong>Aktif Workspace Sayısı:</strong> " . $activeCount['count'] . "</p>";

?>

<script>
async function testDelete(workspaceId) {
    if (!confirm('Workspace ID ' + workspaceId + ' silmek istiyor musunuz?')) {
        return;
    }
    
    console.log('Silme isteği başlatılıyor...');
    
    try {
        const response = await fetch('api/workspaces/delete.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ workspace_id: parseInt(workspaceId) })
        });
        
        console.log('Response status:', response.status);
        console.log('Response headers:', [...response.headers.entries()]);
        
        const text = await response.text();
        console.log('Raw response:', text);
        
        try {
            const data = JSON.parse(text);
            console.log('Parsed data:', data);
            
            if (data.success) {
                alert('✅ Başarılı: ' + data.message);
                location.reload();
            } else {
                alert('❌ Hata: ' + data.error);
            }
        } catch (e) {
            console.error('JSON parse error:', e);
            alert('JSON Parse Hatası. Console\'a bakın.');
        }
        
    } catch (error) {
        console.error('Fetch error:', error);
        alert('Network Hatası: ' + error.message);
    }
}
</script>

<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    table { border-collapse: collapse; margin: 20px 0; }
    th { background: #333; color: white; }
    button { padding: 5px 10px; cursor: pointer; }
</style>

