<?php
require_once 'config/database.php';
require_once 'config/facebook.php';

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   🔧 FACEBOOK MÜŞTERİ İSİMLERİNİ GÜNCELLE\n";
echo "═══════════════════════════════════════════════════════════\n\n";

try {
    // Tüm Facebook müşterilerini bul
    $stmt = $pdo->query("
        SELECT * FROM customers 
        WHERE facebook_id IS NOT NULL 
        AND facebook_id != '' 
        AND (name LIKE 'Facebook Kullanıcı%' OR name = 'Facebook Kullanıcı')
    ");
    $customers = $stmt->fetchAll();
    
    echo "Güncellenecek müşteri sayısı: " . count($customers) . "\n\n";
    
    if (count($customers) === 0) {
        echo "✅ Tüm müşterilerin isimleri zaten güncel!\n";
        exit;
    }
    
    foreach ($customers as $customer) {
        echo "─────────────────────────────────────────────────────────\n";
        echo "Müşteri ID: " . $customer['id'] . "\n";
        echo "Mevcut İsim: " . $customer['name'] . "\n";
        echo "Facebook ID: " . $customer['facebook_id'] . "\n";
        
        // Facebook'tan kullanıcı bilgilerini çek
        if (isset($facebook_config['page_access_token'])) {
            $userInfoUrl = "https://graph.facebook.com/v18.0/{$customer['facebook_id']}?fields=name,first_name,last_name&access_token=" . $facebook_config['page_access_token'];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $userInfoUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            
            $userResponse = curl_exec($ch);
            $userHttpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            
            if ($userHttpCode === 200) {
                $userInfo = json_decode($userResponse, true);
                
                if (isset($userInfo['name'])) {
                    $newName = $userInfo['name'];
                    
                    // İsmi güncelle
                    $updateStmt = $pdo->prepare("UPDATE customers SET name = ? WHERE id = ?");
                    $updateStmt->execute([$newName, $customer['id']]);
                    
                    echo "✅ Yeni İsim: " . $newName . "\n";
                    echo "✅ Güncellendi!\n";
                } else {
                    echo "❌ Facebook'tan isim alınamadı\n";
                    echo "Response: " . $userResponse . "\n";
                }
            } else {
                echo "❌ Facebook API hatası. HTTP Code: " . $userHttpCode . "\n";
                echo "Response: " . $userResponse . "\n";
            }
        } else {
            echo "❌ Page Access Token bulunamadı!\n";
        }
        
        echo "\n";
    }
    
    echo "═══════════════════════════════════════════════════════════\n";
    echo "✅ Güncelleme tamamlandı!\n";
    echo "═══════════════════════════════════════════════════════════\n";
    
} catch (PDOException $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
}
?>

