<?php
$logDir = __DIR__ . '/logs';
$today = date('Y-m-d');
$logFile = $logDir . '/facebook_webhook_' . $today . '.log';

header('Content-Type: text/plain; charset=utf-8');

echo "═══════════════════════════════════════════════════════════\n";
echo "   📱 FACEBOOK MESSENGER WEBHOOK LOGS\n";
echo "═══════════════════════════════════════════════════════════\n\n";

if (file_exists($logFile)) {
    echo "📅 Tarih: $today\n";
    echo "📄 Dosya: $logFile\n";
    echo "📊 Boyut: " . number_format(filesize($logFile) / 1024, 2) . " KB\n\n";
    echo "═══════════════════════════════════════════════════════════\n\n";
    
    $lines = file($logFile);
    $totalLines = count($lines);
    
    // Son 100 satırı göster
    $displayLines = array_slice($lines, -100);
    
    echo implode('', $displayLines);
    
    if ($totalLines > 100) {
        echo "\n\n═══════════════════════════════════════════════════════════\n";
        echo "ℹ️  Son 100 satır gösteriliyor (Toplam: $totalLines satır)\n";
    }
} else {
    echo "❌ Log dosyası bulunamadı: $logFile\n\n";
    echo "Muhtemel nedenler:\n";
    echo "1. Henüz hiç webhook çağrısı yapılmadı\n";
    echo "2. Log klasörü yazma izni yok\n";
    echo "3. Bugün hiç mesaj gelmedi\n\n";
    
    // Diğer log dosyalarını listele
    if (is_dir($logDir)) {
        $files = glob($logDir . '/facebook_webhook_*.log');
        if (!empty($files)) {
            echo "📂 Mevcut log dosyaları:\n";
            rsort($files);
            foreach (array_slice($files, 0, 5) as $file) {
                $date = basename($file, '.log');
                $date = str_replace('facebook_webhook_', '', $date);
                $size = number_format(filesize($file) / 1024, 2);
                echo "   - $date ($size KB)\n";
            }
        }
    }
}

echo "\n═══════════════════════════════════════════════════════════\n";
echo "🔄 Sayfayı yenilemek için: F5 veya Cmd+R\n";
echo "═══════════════════════════════════════════════════════════\n";
?>

